<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Mail\Mailables\Content;

class SendMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $subject;
    public $html;

    /**
     * Create a new message instance.
     */
    public function __construct($user, $subject, $html)
    {
        $this->user = $user;
        $this->subject = $subject;
        $this->html = $html;
    }

    public function content(): Content
    {
        return new Content(
            markdown: 'mail.email'
        );
    }

}
