<?php

namespace App\Models;

use App\Traits\Filterable;
use Illuminate\Database\Eloquent\Model;

class Auction extends Model
{
    use Filterable;

    protected $guarded = [];

    function user()
    {
        return $this->belongsTo(User::class);
    }

    function scopeActive($query)
    {
        return $query->where('status', cons()::ACTIVE);
    }

    function availableToken()
    {
        return $this->tokens - $this->sell_token;
    }
}
