<?php

namespace App\Models;

use App\Traits\Filterable;
use Illuminate\Database\Eloquent\Model;

class AuctionPurchase extends Model
{
    use Filterable;
    protected $guarded = [];

    function auction()
    {
        return $this->belongsTo(Auction::class);
    }

    function seller()
    {
        return $this->belongsTo(User::class, 'seller_id');
    }

    function buyer()
    {
        return $this->belongsTo(User::class, 'buyer_id');
    }
}
