<?php

namespace App\Models;

use App\Traits\Filterable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class Blog extends Model
{
    use HasFactory, Filterable;

    protected $guarded = [];

    protected $casts = [
        'tags' => 'array',
        'seo_tags'=>'array',
        'description' => 'object'
    ];

    function scopeActive($query){
        $query->where('status', cons()::ACTIVE);
    }

    function scopeHomeBlog($query){
        $query->where('is_show_in_home', cons()::ACTIVE);
    }

    function admin(){
        return $this->belongsTo(Admin::class)->withDefault();
    }
    
    function category(){
        return $this->belongsTo(BlogCategory::class)->withDefault();
    }
}
