<?php

namespace App\Models;

use App\Traits\Filterable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BlogCategory extends Model
{
    use HasFactory, Filterable;

    protected $guarded =[];

    function scopeActive($query){
        return $query->where('status', cons()::ACTIVE);
    }

    function blogs(){
        return $this->hasMany(Blog::class,'category_id');
    }
}
