<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Conversation extends Model
{

    protected $guarded = [];

    public function userOne()
    {
        return $this->belongsTo(User::class, 'user_one');
    }

    public function userTwo()
    {
        return $this->belongsTo(User::class, 'user_two');
    }

    public function messages()
    {
        return $this->hasMany(Message::class);
    }

    public static function findOrCreateConversation($userOne, $userTwo)
    {

        $conversation = self::where(function ($query) use ($userOne, $userTwo) {
            $query->where('user_one', $userOne)
                ->where('user_two', $userTwo);
        })
            ->orWhere(function ($query) use ($userOne, $userTwo) {
                $query->where('user_one', $userTwo)
                    ->where('user_two', $userOne);
            })
            ->first();


        if (!$conversation) {
            $conversation = self::create([
                'user_one' => $userOne,
                'user_two' => $userTwo,
            ]);
        }

        return $conversation;
    }
}
