<?php

namespace App\Models;

use App\Traits\Filterable;
use Illuminate\Database\Eloquent\Model;

class Currency extends Model
{
    use Filterable;
    protected $guarded = [];

    function gateways()
    {
        return $this->hasMany(CurrencyGateway::class);
    }

    function scopeActive($query)
    {
        return $query->where('status', cons()::ACTIVE);
    }

    function scopeCrypto($query)
    {
        return $query->where('currency_type', cons()::CRYPTO);
    }

    function scopeFiat($query)
    {
        return $query->where('currency_type', cons()::FIAT);
    }
}
