<?php

namespace App\Models;

use App\Traits\Filterable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Deposit extends Model
{
    use HasFactory, Filterable;


    protected $guarded =[];

    protected $casts = ['proof' => 'array'];


    function user(){
        return $this->belongsTo(User::class,'user_id')->withDefault();
    }
    

    function method(){
        return $this->belongsTo(Gateway::class,'method_id')->withDefault();
    }

    function scopeMyDeposit($query){
        return $query->where('user_id', user()->id);
    }

    function scopeOfflineDeposits($query){
        return $query->where('type', cons()::OFFLINE_GATEWAY);
    }

    function scopeOnlineDeposits($query){
        return $query->where('type', cons()::ONLINE_GATEWAY);
    }

    function scopeAccepted($query){
        return $query->whereIn('status', [cons()::ACCEPTED,cons()::ACTIVE]);
    }
}
