<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Gateway extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = ['parameters' => 'object'];

    function scopeOffline($query)
    {
        return $query->where('gateway_type', cons()::OFFLINE_GATEWAY);
    }

    function scopeOnline($query)
    {
        return $query->where('gateway_type', cons()::ONLINE_GATEWAY);
    }

    function scopeActive($query)
    {
        return $query->where('status', cons()::ACTIVE);
    }

    function currency_gateways()
    {
        return $this->hasMany(CurrencyGateway::class, 'gateway_id');
    }
}
