<?php

namespace App\Models;

use App\Traits\Filterable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class KycRequest extends Model
{
    use HasFactory,Filterable;

    protected $guarded = [];

    protected $casts = [
        'kyc' => 'array'
    ];

    function user(){
        return $this->belongsTo(User::class)->withDefault();
    }

    function scopePending($query){
        return $query->where('status',cons()::PENDING);
    }

    function scopeAccept($query){
       return $query->where('status',cons()::ACCEPTED);
    }


    function scopeReject($query){
       return $query->where('status',cons()::REJECTED);
    }

}
