<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Menu extends Model
{
    use HasFactory;

    protected $guarded =[];

    function page(){
        return $this->belongsTo(Page::class)->withDefault();
    }

    function scopeHeader($query){
        return $query->where('type', cons()::HEADER_MENU);
    }

    function scopeFooter($query){
        return $query->where('type', cons()::FOOTER_MENU);
    }

    function scopeActive($query) {
        $query->whereHas('page', function($item){$item->active();});
    }
    
    function scopeWithoutHome($query){
        $query->whereHas('page', function($item){$item->where('is_default',0);});
    }
}
