<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Page extends Model
{
    use HasFactory;

    protected $guarded =[];
    
    protected $casts = ['seo_keywords' => 'array','description' => 'object'];

    function sections(){
        return $this->hasMany(PageSection::class);
    }

    function menu(){
        return $this->hasOne(Menu::class,'page_id');
    }

    function scopeActive($query){
        return $query->where('status', cons()::ACTIVE);
    }

}
