<?php

namespace App\Models;

use App\Traits\Filterable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReferralCommission extends Model
{
    use HasFactory, Filterable;

    protected $guarded =[];

    function scopeMyCommissions($query){
        return $query->where('who_received', user()->id);
    }

    function commissionFrom(){
        return $this->belongsTo(User::class,'who_initiate')->withDefault();
    }
    
    function commissionTo(){
        return $this->belongsTo(User::class,'who_received')->withDefault();
    }
}
