<?php

namespace App\Models;

use App\Traits\Filterable;
use Illuminate\Database\Eloquent\Model;

class StagePurchase extends Model
{
    use Filterable;

    protected $guarded = [];

    protected $casts = [
        'payment_proof' => 'array'
    ];

    function stage()
    {
        return $this->belongsTo(Stage::class);
    }

    function user()
    {
        return $this->belongsTo(User::class);
    }

    function currency()
    {
        return $this->belongsTo(Currency::class)->withDefault();
    }

    function method()
    {
        return $this->belongsTo(Gateway::class, 'method_id')->withDefault();
    }

    function scopePending($query)
    {
        return $query->where('status', cons()::PENDING);
    }

    function scopeAccepted($query)
    {
        return $query->where('status', cons()::ACCEPTED);
    }

    function scopeRejected($query)
    {
        return $query->where('status', cons()::REJECTED);
    }

    function totalPrice()
    {
        if ($this->currency_id == 0) {
            return formatter($this->total_price) . ' ' . tc()->get('currency');
        } else {
            if ($this->currency->currency_type == cons()::CRYPTO) {
                return formatter($this->total_price, type: cons()::CRYPTO) . ' ' . $this->currency->name;
            }
            return formatter($this->total_price) . ' ' . $this->currency->name;
        }
    }

    function status()
    {
        $html = "";

        if ($this->status == cons()::ACCEPTED) {
            $html =  "<span class='badge badge-light-success'>" . tt_front('Completed') . "</span>";
        } elseif ($this->status == cons()::PENDING) {
            $html =  "<span class='badge badge-info'>" . tt_front('Pending') . "</span>";
        } else {
            $html =  "<span class='badge badge-light-danger'>" . tt_front('Rejected') . "</span>";
        }

        return $html;
    }
}
