<?php

namespace App\Models;

use App\Traits\Filterable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Support extends Model
{
    use HasFactory, Filterable;

    protected $guarded = [];

    function messages(){
        return $this->hasMany(SupportMessage::class);
    }

    function user(){
        return $this->belongsTo(User::class,'user_id')->withDefault();
    }

    function scopeOpenSupport($query){
        return $query->where('status', cons()::SUPPORT_OPEN);
    }

    function scopeAnsweredSupport($query){
        return $query->where('status', cons()::SUPPORT_ANSWERED);
    }

    function scopeCloseSupport($query){
        return $query->where('status', cons()::SUPPORT_CLOSED);
    }
}
