<?php

namespace App\Models;

use App\Traits\Filterable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    use HasFactory,Filterable;

    protected $guarded = [];

    function user(){
        return $this->belongsTo(User::class);
    }

    function scopeMyTransaction($query){
        return $query->where('user_id', user()->id);
    }


}
