<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserAbility extends Model
{
    use HasFactory;

    protected $guarded =[];



    function scopeActive($query){
        return $query->where('status', cons()::ACTIVE);
    }

    function scopeDeactive($query){
        return $query->where('status', cons()::INACTIVE);
    }


    function scopeEmailVerified($query){
        return $query->where('email_verified', cons()::EMAIL_VERIFIED);
    }

    function scopeEmailUnverified($query){
        return $query->where('email_verified', cons()::EMAIL_UNVERIFIED);
    }

    function scopeSmsVerified($query){
        return $query->where('sms_verified', cons()::SMS_VERIFIED);
    }

    function scopeSmsUnverified($query){
        return $query->where('sms_verified', cons()::SMS_UNVERIFIED);
    }

    function scopeKycVerified($query){
        return $query->where('kyc_verified', cons()::KYC_VERIFIED);
    }

    function scopeKycUnverified($query){
        return $query->where('kyc_verified', cons()::KYC_UNVERIFIED);
    }

}
