<?php

namespace App\Models;

use App\Traits\Filterable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Withdraw extends Model
{
    use HasFactory, Filterable;

    protected $guarded =[];

    function method(){
        return $this->belongsTo(WithdrawMethod::class,'method_id')->withDefault();
    }

    function user(){
        return $this->belongsTo(User::class)->withDefault();
    }

    function scopeMyWithdraw($query){
        return $query->where('user_id', user()->id);
    }

    function scopeAccepted($query){
        return $query->whereIn('status', [cons()::ACCEPTED,cons()::ACTIVE]);
    }
}
