<?php

namespace App\Providers;

use App\Services\Backend\Settings\CacheSettingService;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Str;
use Nwidart\Modules\Facades\Module;
class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {

    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {


        Paginator::useBootstrapFive();

        $this->app->singleton(CacheSettingService::class, function ($app) {
            return new CacheSettingService();
        });

        if (isInstalled() == 'installed') {
            $this->app->singleton(CacheSettingService::class, function ($app) {
                return new CacheSettingService();
            });

            $frontendPath = currentActiveTemplatePath();

            if (config('app.theme_type') == 'module') {
                $modules = Module::all();

                foreach ($modules as $module) {
                    $moduleViewsPath = module_path($module->getName(), 'resources/views');
                    if (is_dir($moduleViewsPath)) {
                        View::addNamespace(Str::studly($module->getName()), $moduleViewsPath);
                    }
                }

                $frontendPath = module_path(config('app.active_theme'), 'resources/views/frontend') . '/' . currentActiveTemplate();
            }

            
            View::addNamespace('frontend', $frontendPath);
            View::addNamespace('user', userLayouts());
        }

    }
}
