<?php
namespace App\Scopes;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;

class NonSoftDeletedForeignScope implements Scope
{
    public function apply(Builder $builder, Model $model)
    {
        $excludedRelations = $model->getExcludedRelations();

        foreach ($excludedRelations as $relation) {
            
            $builder->whereHas($relation, function ($query) {
                $query->whereNull('deleted_at');
            });
        }
    }
}
