<?php
namespace App\Services\Backend\Admin;

use Illuminate\Support\Facades\Hash;

class AdminProfileUpdate{
    function updateProfile(array $payloads){
       
        if(isset($payloads['image'])){
            $payloads['image'] = storeFile($payloads['image'],'staff', admin()->image);
        }

        $admin = admin();


        $admin->update($payloads);


        return ['status' => true,'message' => tt_trans('Admin profile Updated Succesfully',cons()::LANGUAGE_NOTIFICATION)];
    }

    function updatePassword(array $payloads){

        if(!Hash::check($payloads['old_password'], admin()->password)){
            return ['status' => false,'message' => tt_trans('Old password not matched',cons()::LANGUAGE_NOTIFICATION)];
        }

        $password = bcrypt($payloads['password']);
        $admin = admin();

        $admin->password = $password;

        $admin->save();
        
        return ['status' => true,'message' => tt_trans('Password Changed Successfully',cons()::LANGUAGE_NOTIFICATION)];
    }
}