<?php

namespace App\Services\Backend\Auth;

use App\Models\Admin;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;

class AuthenticationService
{
    function login(array $payloads)
    {
        $remember = isset($payloads['remeber']) && $payloads['remember'] == 'on' ? true : false;

        $admin = Admin::where('email', $payloads['email'])->orWhere('username', $payloads['email'])->first();

        if (!$admin) {
            return ['status' => false, 'message' => tt_trans('Invalid Admin Email', cons()::LANGUAGE_NOTIFICATION)];
        }

        if(!$admin->status){
            return ['status' => false, 'message' => tt_trans('Your account is inactive', cons()::LANGUAGE_NOTIFICATION)];
        }

        if (Auth::guard('admin')->attempt(['email' => $payloads['email'], 'password' => $payloads['password']], $remember) || Auth::guard('admin')->attempt(['username' => $payloads['email'], 'password' => $payloads['password']], $remember)) {
            return ['status' => true, 'message' => tt_trans('Successfully logged in', cons()::LANGUAGE_NOTIFICATION)];
        }

        return ['status' => false, 'message' => tt_trans('Invalid Credentials', cons()::LANGUAGE_NOTIFICATION)];
    }

    function sendResetCode(array $payloads)
    {
        $token = rand(1, 999999);

        DB::table('password_reset_tokens')->updateOrInsert(
            ['email' => $payloads['email']],
            [
                'token' => $token,
            ],
        );

        sendMail($payloads['email'], ['code' => $token], emailTemplate('email_verify'));

        return ['status' => true, 'message' => tt_trans('Reset code send to your mail', cons()::LANGUAGE_NOTIFICATION)];
    }

    function codeVerify(array $payloads)
    {
        $email = Cache::get('email');

        if (!$email) {
            return ['status' => false, 'message' => tt_trans('Code Expired', cons()::LANGUAGE_NOTIFICATION)];
        }
        $isValidCode = DB::table('password_reset_tokens')
            ->where('email', $email)
            ->where('token', $payloads['code'])
            ->first();

        if (!$isValidCode) {
            return ['status' => false, 'message' => tt_trans('Invalid Code', cons()::LANGUAGE_NOTIFICATION)];
        }

        DB::table('password_reset_tokens')
            ->where('email', $email)
            ->where('token', $payloads['code'])
            ->delete();

        return ['status' => true, 'message' => tt_trans('Verfiy code successfully', cons()::LANGUAGE_NOTIFICATION)];
    }

    function resetPassword(array $payloads)
    {
        $email = Cache::get('email');

        if (!$email) {
            return ['status' => false, 'message' => tt_trans('Code Expired', cons()::LANGUAGE_NOTIFICATION)];
        }

        $admin = Admin::where('email', $email)->first();

        if (!$admin) {
            return ['status' => false, 'message' => tt_trans('Invalid Email', cons()::LANGUAGE_NOTIFICATION)];
        }

        $admin->password = bcrypt($payloads['password']);

        $admin->save();

        return ['status' => true, 'message' => tt_trans('Password Reset Successfully', cons()::LANGUAGE_NOTIFICATION)];
    }
}
