<?php

namespace App\Services\Backend\Blog;

use App\Models\Blog;
use Illuminate\Support\Str;

class BlogService{
    function createBlog(array $payloads){

        if(isset($payloads['image'])){
            $payloads['image'] = storeFile($payloads['image'],'blogs');
        }


        $payloads['slug'] = Str::slug($payloads['title']);

        $payloads['admin_id'] = admin()->id;

        Blog::create($payloads);


        return ['status' => true,'message' => tt_trans('Blog created successfully',cons()::LANGUAGE_NOTIFICATION)];
        
    }

    function updateBlog(array $payloads, $blog){
        
        
        if(isset($payloads['image'])){
            $payloads['image'] = storeFile($payloads['image'],'blogs', $blog->image);
        }

        $payloads['slug'] = Str::slug($payloads['title']);

        $payloads['admin_id'] = admin()->id;

        $blog->update($payloads);


        return ['status' => true,'message' => tt_trans('Blog updated successfully',cons()::LANGUAGE_NOTIFICATION)];
    }
    
    function delete($blog){
        removeImage($blog, 'blogs');

        $blog->delete();

        return ['status' => true,'message' => tt_trans('blog deleted successfully', cons()::LANGUAGE_NOTIFICATION)];
    }
}