<?php

namespace App\Services\Backend\Blog;

use App\Models\BlogCategory;

use Illuminate\Support\Str;

class CategoryService{
    function addCategory(array $payloads){

        $payloads['slug'] = Str::slug($payloads['name']);

        BlogCategory::create($payloads);

        return['status' => true,'message' => tt_trans('Blog category created successfully',cons()::LANGUAGE_NOTIFICATION)];
    }

    function updateCategory(array $payloads, $category){

        $payloads['slug'] = Str::slug($payloads['name']);


        $category->update($payloads);

        return['status' => true,'message' => tt_trans('Blog category updated successfully',cons()::LANGUAGE_NOTIFICATION)];
    }

    function deleteCategory($category){
        $category->delete();

        return['status' => true,'message' => tt_trans('Blog category deleted successfully',cons()::LANGUAGE_NOTIFICATION)];
    }
}