<?php

namespace App\Services\Backend\Category;

use App\Models\Category;

class CategoryService
{
    public function create($payloads)
    {
        $userCommission = $payloads['ad_price'] - $payloads['commission'];

        Category::create([
            'type' => $payloads['type'],
            'admin_commission' => $payloads['admin_commission'],
            'ad_price' => $payloads['ad_price'],
            'user_commission' => $userCommission,
            'status' => 1
        ]);

    }

    public function update($payloads, $id)
    {
        $category = Category::findOrFail($id);

        $userCommission = $payloads['ad_price'] - $payloads['admin_commission'];

        $category->update([
            'type' => $payloads['type'],
            'admin_commission' => $payloads['admin_commission'],
            'ad_price' => $payloads['ad_price'],
            'user_commission' => $userCommission,
        ]);
    }

    public function changeStatus($id)
    {
        $category = Category::findOrFail($id);

        if ($category->status) {

            $category->status = false;
        } else {

            $category->status = true;
        }

        $category->save();
    }
}
