<?php

namespace App\Services\Backend\Cms;

use App\Models\Content;
use App\Models\Theme;

class ContentManagementService
{
    function arrayRecursiveDiff($array1, $array2)
    {
        $result = [];

        foreach ($array1 as $key => $value) {
            // If key does not exist in array2 or values are different
            if (array_key_exists($key, $array2)) {
                if (is_array($value)) {
                    // Recursively compare if values are arrays
                    $recursiveDiff = $this->arrayRecursiveDiff($value, $array2[$key]);
                    if (!empty($recursiveDiff)) {
                        $result[$key] = $recursiveDiff;
                    }
                } elseif ($value != $array2[$key]) {
                    // Values are different
                    $result[$key] = $value;
                }
            } else {
                // Key does not exist in array2
                $result[$key] = $value;
            }
        }

        return $result;
    }

    function updateContent(array $payloads, $section, $sectionContent = null)
    {
        $contents = $payloads['content'];


        $type = $payloads['type'];

        $images = [];

        $image_keys = [];


        if ($sectionContent) {
            $images = $this->arrayRecursiveDiff((array) $sectionContent->content, $contents);
        }

        foreach ($contents as $key => $content) {
            if (!is_array($contents[$key]) && is_file($contents[$key])) {
                if (!array_key_exists($key, $images)) {
                    $image_keys[] = $key;
                }
                $contents[$key] = storeFile($contents[$key], 'cms', $sectionContent?->content->$key ?? '');
            }
        }

        foreach ($images as $key => $value) {
            $image_keys[] = $key;
            if (!array_key_exists($key, $contents)) {
                $contents[$key] = $value;
            }
        }

        array_unique($image_keys);

        $theme = Theme::active()->first();

        if (!$sectionContent) {
            Content::create([
                'content' => $contents,
                'type' => $type,
                'section_name' => $section,
                'theme_id' => $theme->id,
                'image_keys' => $image_keys,
            ]);
        } else {
            $sectionContent->update([
                'content' => $contents,
                'type' => $type,
                'section_name' => $section,
                'theme_id' => $theme->id,
                'image_keys' => $image_keys,
            ]);
        }

        return ['status' => true, 'message' => tt_trans('Content Updated Successfully', cons()::LANGUAGE_NOTIFICATION)];
    }
}
