<?php

namespace App\Services\Backend\Currency;

use App\Models\Currency;
use App\Models\CurrencyGateway;

class CurrencyService
{

    public function addCurrency($payloads)
    {

        $currency = new Currency();
        $currency->name = $payloads['name'];
        $currency->exchange_rate = $payloads['exchange_rate'];
        $currency->status = $payloads['status'];
        $currency->currency_type = $payloads['currency_type'];
        $currency->icon = storeFile($payloads['icon'], 'currency');
        $currency->save();

        foreach ($payloads['gateways'] as $gateway) {
            $gatewayCurrency = new CurrencyGateway();
            $gatewayCurrency->gateway_id =  $gateway;
            $gatewayCurrency->currency_id = $currency->id;
            $gatewayCurrency->save();
        }

        return ['status' => true, 'message' => 'Currencies added successfully'];
    }

    public function updateCurrency($payloads, $currency)
    {

        $currency->name = $payloads['name'];
        $currency->exchange_rate = $payloads['exchange_rate'];
        $currency->status = $payloads['status'];
        $currency->currency_type = $payloads['currency_type'];

        if (isset($payloads['icon'])) {
            $currency->icon = storeFile($payloads['icon'], 'currency', $currency->icon);
        }

        $currency->save();

        CurrencyGateway::where('currency_id', $currency->id)->delete();

        foreach ($payloads['gateways'] as $gateway) {
            $gatewayCurrency = new CurrencyGateway();
            $gatewayCurrency->gateway_id =  $gateway;
            $gatewayCurrency->currency_id = $currency->id;
            $gatewayCurrency->save();
        }

        return ['status' => true, 'message' => 'Currencies updated successfully'];
    }

    public function deleteCurrency($currency) {
        $currency->delete();
        return ['status' => true, 'message' => 'Currencies deleted successfully'];
    }
}
