<?php

namespace App\Services\Backend\Deposit;

use App\Events\NotificationEvent;
use App\Models\Transaction;

class DepositService
{
    function acceptDeposit($deposit)
    {
        $deposit->status = cons()::ACCEPTED;

        $deposit->save();

        $user = $deposit->user;

        $user->balance = $user->balance + $deposit->amount;

        $user->save();

        $transaction = Transaction::create([
            'user_id' => $user->id,
            'amount' => $deposit->amount,
            'reason' => 'Deposit via ' . $deposit->method->name,
            'trx' => getTrx(),
            'type' => '+',
        ]);

        sendReferralCommission($user, $transaction, cons()::DEPOSIT);

        $message = 'Congratutaions! your deposit request accepted';

        event(new NotificationEvent($deposit, $user, $message, 'deposit_accepted'));

        return ['status' => true, 'message' => tt_trans('Deposit accepted successfully', cons()::LANGUAGE_NOTIFICATION)];
    }

    function rejectDeposit($deposit, $payloads)
    {
        $deposit->status = cons()::REJECTED;

        $deposit->reason = $payloads['reason'];

        $deposit->save();

        $user = $deposit->user;

        $message = 'Ohh! your deposit request rejected';
        
        event(new NotificationEvent($deposit, $user, $message, 'deposit_rejected'));

        return ['status' => true, 'message' => tt_trans('Deposit rejected successfully', cons()::LANGUAGE_NOTIFICATION)];
    }
}
