<?php

namespace App\Services\Backend\Gateway;

use App\Models\Gateway;

class GatewayService
{
    function updateGateway(array $payloads, $gateway)
    {
        if (isset($payloads['image'])) {
            $payloads['image'] = storeFile($payloads['image'], 'gateways', $gateway->image);
        }

        if (isset($payloads['parameters']['sending_options']['qr_code'])) {
            $isQrImageAvailable = $payloads['parameters']['sending_options']['qr_code'];
            $payloads['parameters']['sending_options']['qr_code'] = $isQrImageAvailable ? storeFile($payloads['parameters']['sending_options']['qr_code'] ,'gateways',(isset($gateway->parameters->qr_code) ?  $gateway->parameters->qr_code : '')) : (isset($gateway->parameters->qr_code) ?  $gateway->parameters->qr_code : '');
        }else{
            if(isset($payloads['parameters']['type']) && $payloads['parameters']['type'] == 'crypto'){
                $payloads['parameters']['sending_options']['qr_code'] = isset($gateway->parameters->qr_code) ?  $gateway->parameters->qr_code : '';
            }
        }

        $gateway->update($payloads);

        return ['status' => true, 'message' => tt_trans('Gateway updated successfully', cons()::LANGUAGE_NOTIFICATION)];
    }

    function createGateway(array $payloads)
    {
        if (isset($payloads['image'])) {
            $payloads['image'] = storeFile($payloads['image'], 'gateways');
        }

        if ($payloads['currency_type'] == cons()::CRYPTO && isset($payloads['parameters']['sending_options']['qr_code'])) {
            $payloads['parameters']['sending_options']['qr_code'] = storeFile($payloads['parameters']['sending_options']['qr_code'], 'gateways');
        }

        $payloads['gateway_type'] = cons()::OFFLINE_GATEWAY;

        Gateway::create($payloads);

        return ['status' => true, 'message' => tt_trans('Gateway created successfully', cons()::LANGUAGE_NOTIFICATION)];
    }
}
