<?php

namespace App\Services\Backend\IcoSetting;

use App\Models\IcoSetting;

class IcoSettingService
{
    public function storeOrUpdate($payloads)
    {

        $setting = IcoSetting::first();

        if (!$setting) {
            $setting = new IcoSetting;
        }

        $setting->token_name = $payloads['token_name'];
        $setting->token_symbol = $payloads['token_symbol'];
        $setting->currency_id = $payloads['currency_id'];
        $setting->auction_buy_percentage = $payloads['auction_buy_percentage'];
        $setting->auction_refund_percentage = $payloads['auction_refund_percentage'];

        if (isset($payloads['white_paper'])) {
            $setting->white_paper = storeFile($payloads['white_paper'], 'white_paper');
        }

        if (isset($payloads['icon'])) {
            $setting->icon = storeFile($payloads['icon'], 'ico_icon',$setting->icon);
        }

        $setting->save();

        return ['status' => true, 'message' => 'Ico setting updated successfully'];
    }
}
