<?php
namespace App\Services\Backend\Kyc;

use App\Events\NotificationEvent;

class KycRequestService{
    function verifyKycRequest($kyc){

        $user = $kyc->user;

        $user->ability->kyc_verified = cons()::ACTIVE;

        $user->ability->save();

        $kyc->status = cons()::ACCEPTED;

        $kyc->save();

        event(new NotificationEvent($kyc,$user, 'Kyc Verification Accepted successfully at '.now(), 'accept_kyc'));

        return ['status' => true ,'message' => tt_trans('Kyc verify request accepted',cons()::LANGUAGE_NOTIFICATION)];


    }
    
    function rejectKycRequest(array $payloads, $kyc){

        $user = $kyc->user;

        $user->ability->kyc_verified = cons()::REJECTED;

        $user->ability->save();

        $kyc->status = cons()::REJECTED;
        
        $kyc->reason = $payloads['reason'];

        $kyc->save();

        event(new NotificationEvent($kyc,$user, 'Kyc Request rejected', 'reject_kyc'));

        return ['status' => true ,'message' => tt_trans('Kyc verify request rejected',cons()::LANGUAGE_NOTIFICATION)];


    }
}