<?php

namespace App\Services\Backend\Menu;

use App\Models\Menu;
use App\Models\Page;
use Illuminate\Support\Facades\DB;

class MenuService{
    function updateMenu(array $payloads){

        Menu::query()->delete();

        $header = [];
        $footer = [];

        foreach ($payloads['header'] as $key=> $id) {
            $page = Page::find($id);

            $header[$key] = [
                'page_id' => $page->id,
                'name' => $page->name,
                'type' => cons()::HEADER_MENU,
                'created_at' => now(),
                'updated_at' => now()
            ];
        }

        DB::table('menus')->insert($header);


        if(isset($payloads['footer'])){

            foreach ($payloads['footer'] as $key=> $id) {
                $page = Page::find($id);
    
                $footer[$key] = [
                    'page_id' => $page->id,
                    'name' => $page->name,
                    'type' => cons()::FOOTER_MENU,
                    'created_at' => now(),
                    'updated_at' => now()
                ];
            }
            DB::table('menus')->insert($footer);
        }

        return ['status'=> true,'message' => tt_trans('Menu updated successfully',cons()::LANGUAGE_NOTIFICATION)];

    }
}