<?php

namespace App\Services\Backend\Page;

use App\Models\Page;
use App\Models\PageSection;

class PageService
{
    function createPage(array $payloads)
    {
        $sections = $payloads['sections'] ?? [];

        unset($payloads['sections']);
        
        if(isset($payloads['description']) && $payloads['description']){
            $payloads['is_description'] = cons()::ACTIVE;
        }else{
            $payloads['is_description'] = cons()::INACTIVE;
        }


        $page = Page::create($payloads);

        if (count($sections) > 0) {
            foreach ($sections as $section) {
                PageSection::create([
                    'page_id' => $page->id,
                    'name' => $section,
                ]);
            }
        }

        return ['status' => true, 'message' => tt_trans('Page created successfully', cons()::LANGUAGE_NOTIFICATION)];
    }

    function updatePage(array $payloads, $page)
    {

        $sections = $payloads['sections'] ?? [];

        unset($payloads['sections']);

        if(isset($payloads['description']) && $payloads['description']){
            $payloads['is_description'] = cons()::ACTIVE;
        }else{
            $payloads['is_description'] = cons()::INACTIVE;
        }

        $page->update($payloads);



        if (count($sections) > 0) {
            $page->sections()->delete();

            foreach ($sections as $section) {
                PageSection::create([
                    'page_id' => $page->id,
                    'name' => $section,
                ]);
            }
        }else{
            $page->sections()->delete();
        }

        return ['status' => true, 'message' => tt_trans('Page updated successfully', cons()::LANGUAGE_NOTIFICATION)];
    }

    function delete($page){
        $page->sections()->delete();
        $page->menu()->delete();
        $page->delete();

        return ['status' => true, 'message' => tt_trans('Page deleted successfully', cons()::LANGUAGE_NOTIFICATION)];
    }
}
