<?php

namespace App\Services\Backend\Referral;

use App\Models\ReferralLevel;
use App\Models\ReferralSetting;

class ReferralService{
    function referralSettingUpdate(array $payloads){
        $setting = ReferralSetting::where('name', $payloads['name'])->first();

        $setting->type = $payloads['type'];
        $setting->status = $payloads['status'];

        $setting->save();

        return ['status' => true,'message' => tt_trans('Referral settings updated successfull',cons()::LANGUAGE_NOTIFICATION)];
    }

    function store(array $payloads){
        
        $setting = ReferralSetting::find($payloads['referral_setting_id']);

        if(isset($payloads['image'])){
            $payloads['image'] = storeFile($payloads['image'],'referral', tc()->get('image'));
        }
        
        ReferralLevel::create([
            'referral_setting_id' => $setting->id,
            'name' => $payloads['name'],
            'commission' => $payloads['commission'],
            'image' => $payloads['image'] ?? ''
        ]);

        return ['status' => true,'message' => tt_trans('Referral level created successfull',cons()::LANGUAGE_NOTIFICATION)];
    }

    function update(array $payloads){

        $setting = ReferralSetting::find($payloads['referral_setting_id']);

        $level = ReferralLevel::find(request()->levelid);

        if(isset($payloads['image'])){
            $payloads['image'] = storeFile($payloads['image'],'referral', tc()->get('image'));
            $level->image = $payloads['image'];
        }

        $level->name = $payloads['name'];
        $level->commission = $payloads['commission'];
        $level->save();

        return ['status' => true,'message' => tt_trans('Referral level updated successfull',cons()::LANGUAGE_NOTIFICATION)];
    }

    function delete($level){
        $level->delete();

        return ['status' => true,'message' => tt_trans('Level deleted successfully', cons()::LANGUAGE_NOTIFICATION)];
    }
}