<?php

namespace App\Services\Backend\Role;

use Spatie\Permission\Models\Role;

class RoleService{

    function insertRole(array $payloads){

        $role = Role::create([
            'name' => $payloads['name'],
            'guard_name' => 'admin'
        ]);

        $role->syncPermissions($payloads['permissions']);

        return ['status' => true,'message' => tt_trans('Role created successfully', cons()::LANGUAGE_NOTIFICATION)];
    }

    function updateRole(array $payloads, $role){
        $role->name = $payloads['name'];

        $role->save();

        $role->syncPermissions($payloads['permissions']);

        return ['status' => true,'message' => tt_trans('Role updated successfully', cons()::LANGUAGE_NOTIFICATION)];
    }
}