<?php
namespace App\Services\Backend\Settings;

use App\Models\Setting;
use Illuminate\Support\Facades\Cache;

class CacheSettingService
{
    protected $cacheKey = 'settings';

    public function get($key)
    {
        $settings = Cache::get($this->cacheKey);

        if (!$settings) {
            $settings = Setting::first()->toArray();
            Cache::put($this->cacheKey, $settings, now()->addMinutes(60));
        }

        return $settings[$key] ?? null;
    }

    public function refresh()
    {
        Cache::forget($this->cacheKey);
        
        $settings = Setting::first()?->toArray();
        

        Cache::put($this->cacheKey, $settings, now()->addMinutes(60));
    }
}
