<?php

namespace App\Services\Backend\Settings;

use App\Models\KycSetting;
use App\Models\Setting;
use DateTimeZone;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;

class SettingsService
{
    function getTimzone()
    {
        $regions = array(
            'Africa' => DateTimeZone::AFRICA,
            'America' => DateTimeZone::AMERICA,
            'Antarctica' => DateTimeZone::ANTARCTICA,
            'Aisa' => DateTimeZone::ASIA,
            'Atlantic' => DateTimeZone::ATLANTIC,
            'Europe' => DateTimeZone::EUROPE,
            'Indian' => DateTimeZone::INDIAN,
            'Pacific' => DateTimeZone::PACIFIC
        );

        $timezones = array();

        foreach ($regions as $name => $mask) {
            $zones = DateTimeZone::listIdentifiers($mask);
            foreach ($zones as $timezone) {
                // Remove region name and add a sample time
                $timezones[$name][$timezone] = substr($timezone, strlen($name) + 1);
            }
        }

        return $timezones;
    }

    function settingsUpdate(array $payloads){

        Artisan::call('cache:clear');

        if(isset($payloads['background'])){
            $payloads['background'] = storeFile($payloads['background'],'background',tc()->get('background'));
        } 
        
        $settings = Setting::first();

        $settings->update($payloads);

        setEnvironmentValue(['TIMEZONE' => $payloads['timezone']]);
        
        return ['status' => true,'message' => tt_trans('Settings updated Successfully', cons()::LANGUAGE_NOTIFICATION)];

    }

    function pluginUpdate(array $payloads){

        $settings = Setting::first();

        $settings->update($payloads);


        return ['status' => true,'message' => tt_trans('Plugins settings updated Successfully', cons()::LANGUAGE_NOTIFICATION)];
    }

    function updateKycSettings(array $payloads){

        KycSetting::latest()->delete();

        $insertData = $payloads['kyc'];

        DB::table('kyc_settings')->insert($insertData);

        return ['status' => true,'message' => tt_trans('Kyc settings updated Successfully', cons()::LANGUAGE_NOTIFICATION)];
        
    }

    function seoSettings(array $payloads) {
        $settings = Setting::first();

        $settings->update($payloads);

        return ['status' => true,'message' => tt_trans('Seo settings updated Successfully', cons()::LANGUAGE_NOTIFICATION)];
    }

    function updateEmailConfig(array $payloads){
        $settings = Setting::first();

        $settings->update($payloads);

        
        setEnvironmentValue([
            'MAIL_HOST'=> $payloads['email_configurations']['host'],
            'MAIL_PORT'=>$payloads['email_configurations']['port'],
            'MAIL_USERNAME'=>$payloads['email_configurations']['username'],
            'MAIL_PASSWORD'=>$payloads['email_configurations']['password'],
            'MAIL_ENCRYPTION'=>$payloads['email_configurations']['encryption'],
            'MAIL_FROM_ADDRESS'=>$payloads['email_configurations']['email_from'],
            'MAIL_FROM_NAME'=>tc()->get('sitename')
        ]);

        return ['status' => true,'message' => tt_trans('Email settings updated Successfully', cons()::LANGUAGE_NOTIFICATION)];
    }

    function maintanaceSettings(array $payloads){
        $settings = Setting::first();

        $settings->update($payloads);

        return ['status' => true,'message' => tt_trans('Maintanance updated Successfully', cons()::LANGUAGE_NOTIFICATION)];
    }
}
