<?php

namespace App\Services\Backend\Staff;

use App\Models\Admin;

class StaffService {
    function storeStaff(array $payloads){
        $admin = Admin::create([
            'username' => $payloads['username'],
            'email' => $payloads['email'],
            'password' => bcrypt($payloads['password']),
            'image' => isset($payloads['image']) ? storeFile($payloads['image'],'staff') : "",
            'status' => $payloads['status']
        ]);


        $admin->syncRoles($payloads['roles']);


        return ['status' => true,'message' => tt_trans('Staff created successfully', cons()::LANGUAGE_NOTIFICATION)];
    }


    function updateStaffInfo(array $payloads, $admin){

        $admin->update([
            'username' => $payloads['username'],
            'email' => $payloads['email'],
            'password' => isset($payloads['password']) ?  bcrypt($payloads['password']): $admin->password,
            'image' => isset($payloads['image']) ? storeFile($payloads['image'],'staff', $admin->image) : $admin->image,
            'status' => $payloads['status']
        ]);
        

        $admin->syncRoles($payloads['roles']);


        return ['status' => true,'message' => tt_trans('Staff updated successfully', cons()::LANGUAGE_NOTIFICATION)];
    }

    function delete($admin){
        $admin->syncRoles($admin->roles()->pluck('name'));

        removeImage($admin, 'staff');

        $admin->delete();

        return ['status' => true,'message' => tt_trans('Staff deleted successfully', cons()::LANGUAGE_NOTIFICATION)];
    }
}