<?php

namespace App\Services\Backend\Support;

use App\Events\NotificationEvent;
use App\Models\SupportFile;
use App\Models\SupportMessage;

class SupportService{
    function replySupport(array $payloads, $support){

        $support->status = cons()::SUPPORT_ANSWERED;

        $support->save();

        $message = SupportMessage::create([
            'support_id' => $support->id,
            'message' => $payloads['message'],
            'type' => 'admin',
            'admin_id' => admin()->id
        ]);

        if (isset($payloads['files'])) {
            foreach ($payloads['files'] as $file) {
                SupportFile::create([
                    'support_id' => $support->id,
                    'support_message_id' => $message->id,
                    'file' => storeFile($file, 'support')
                ]);
            }
        }

        $message = 'admin reply for a support Ticket';

        pushNotification(['user_id' => $support->user->id, 'message' => $message , 'type' => 'success'],'user-notification');

        return ['status' => true, 'message' => tt_trans('Reply support ticket successfully',cons()::LANGUAGE_NOTIFICATION)];
    }

    function closeTicket($support){

        $support->status = cons()::SUPPORT_CLOSED;

        $support->save();

        $message = 'admin closed support Ticket #'.$support->trx;

        event(new NotificationEvent($support,  $support->user, $message, 'support_closed'));

        return ['status' => true, 'message' => tt_trans('Support closed successfully',cons()::LANGUAGE_NOTIFICATION)];
    }
}