<?php

namespace App\Services\Backend\Update;

use App\Models\Setting;
use App\Models\Version;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\File;
use ZipArchive;

class UpdateService
{
    function uploadVersion(array $payloads)
    {
        $nextversion = getProjectVersions()[tc()->get('current_version')]['next_version'];

        $path = cons()::IMAGE_UPLOAD_ROOT_PATH . 'versions';

        $zipfile = $payloads['file']->getClientOriginalName();

        $uploadFolderName = pathinfo($payloads['file']->getClientOriginalName(), PATHINFO_FILENAME);

        if ($uploadFolderName != $nextversion) {
            return ['status' => false, 'message' => tt_trans('Invalid Version file.', cons()::LANGUAGE_NOTIFICATION)];
        }

        $payloads['file']->move($path, $zipfile);

        $zip = new ZipArchive();

        if ($zip->open($path . '/' . $zipfile) === true) {
            $fileExists = false;

            $filesInZip = [];

            for ($i = 0; $i < $zip->numFiles; $i++) {
                $fileName = $zip->getNameIndex($i);
                $filesInZip[] = $fileName;
            }

            if (in_array($uploadFolderName . '/config.php', $filesInZip)) {
                $zip->extractTo('versions');
                $zip->close();

                $file = cons()::IMAGE_UPLOAD_ROOT_PATH . 'versions/' . $zipfile;

                if (file_exists($file)) {
                    unlink($file);
                }

                $this->installUpdate($uploadFolderName);

                return ['status' => true, 'message' => tt_trans('ZIP file uploaded and extracted successfully.', cons()::LANGUAGE_NOTIFICATION)];
            } else {
                $file = cons()::IMAGE_UPLOAD_ROOT_PATH . 'versions';

                if (file_exists($file)) {
                    File::deleteDirectory($file);
                }

                return ['status' => false, 'message' => tt_trans('Invalid Zip File uploaded.', cons()::LANGUAGE_NOTIFICATION)];
            }
        }

        $file = cons()::IMAGE_UPLOAD_ROOT_PATH . 'versions/' . $zipfile;

        if (file_exists($file)) {
            unlink($file);
        }

        return ['status' => false, 'message' => tt_trans('file is not uploaded', cons()::LANGUAGE_NOTIFICATION)];
    }

    function installUpdate($folder_name)
    {
        $updateFolder = 'versions/' . $folder_name;

        if (!File::exists($updateFolder)) {
            return ['status' => false, 'message' => tt_trans('Invalid update folder', cons()::LANGUAGE_NOTIFICATION)];
        }

        $config = require $updateFolder . '/config.php';

        foreach ($config as $key => $con) {


            $addon_file_folder = $updateFolder . '/' . $con;


            if($key == 'asset'){
                $where_to_place_file_folder =$_SERVER['DOCUMENT_ROOT'] . '/' . $con;
            }else{
                $where_to_place_file_folder = base_path() . '/' . $con;
            }
    

            $this->findFolderAndReplace($addon_file_folder, $where_to_place_file_folder);

        }

        Version::create([
            'version' => $folder_name,
        ]);

        $setting = Setting::first();

        $setting->update([
            'current_version' => $folder_name,
        ]);

        Artisan::call('migrate');
    }

    public function findFolderAndReplace($addon_file_folder, $where_to_place_file_folder)
    {


        $all_update_views = $this->getDirectoryFiles($addon_file_folder);

        $all_old_views = $this->getDirectoryFiles($where_to_place_file_folder);
        

        foreach ($all_update_views as $new_file) {
            $not_allow_to_update_files_list = ['dynamic-style.css', 'dynamic-style.js', '.git', '.idea', '.DS_Store']; //only file/folder

            if (in_array($new_file, $not_allow_to_update_files_list)) {
                continue;
            }

            if (is_dir($addon_file_folder . '/' . $new_file)) {
                $old_file = array_search($new_file, $all_old_views);

                $folder_name = isset($all_old_views[$old_file]) ? $all_old_views[$old_file] : '';

                if (!file_exists($where_to_place_file_folder . '/' . $new_file)) {
                    if (!mkdir($concurrentDirectory = $where_to_place_file_folder . '/' . $new_file) && !is_dir($concurrentDirectory)) {
                        throw new \RuntimeException(sprintf('Directory "%s" was not created', $concurrentDirectory));
                    }
                    $folder_name = $new_file;
                }
                $this->findFolderAndReplace($addon_file_folder . '/' . $new_file, $where_to_place_file_folder . '/' . $folder_name);
            } else {
                $file_index = array_search($new_file, $all_old_views);
                $addon_file_folder_new = $addon_file_folder;
                $script_where_to_place_file_folder = $where_to_place_file_folder;

                $folder_name = $all_old_views[$file_index] ?? $new_file;
                $update_able_file_size = $this->getFileSize($addon_file_folder_new . '/' . $new_file);
                $script_able_file_size = $this->getFileSize($script_where_to_place_file_folder . '/' . $folder_name);

                $this->updateFile($addon_file_folder . '/' . $new_file, $script_where_to_place_file_folder . '/' . $folder_name);
                if (!is_dir($script_where_to_place_file_folder) && !file_exists($script_where_to_place_file_folder . '/' . $new_file)) {
                    file_put_contents($script_where_to_place_file_folder . '/' . $new_file, file_get_contents($addon_file_folder_new . '/' . $new_file));
                }
            }
        }
    }

    public function getDirectoryFiles($dir)
    {
        $get_file = array_diff(scandir($dir), ['.', '..']);

        return $get_file;
    }

    public function updateFile($update_file, $old_file)
    {
        $update_data = file_get_contents($update_file);
        file_put_contents($old_file, $update_data);
    }

    public function getFileSize($file_path)
    {
        return file_exists($file_path) ? filesize($file_path) : 0;
    }
}
