<?php

namespace App\Services\Backend\User;

use App\Events\NotificationEvent;
use App\Filters\BulkEmailFilter;
use App\Models\Transaction;
use App\Models\User;

class UserService{
    function sendBulkMail(array $payloads){

        $users = User::filter([BulkEmailFilter::class])->get();

        if($users->isEmpty()){
            return ['status' => false,  'message' => tt_trans('No User Found',cons()::LANGUAGE_NOTIFICATION)];
        }

        foreach ($users as $user) {
            event(new NotificationEvent($user, $user, $payloads['message'],'general_mail'));
        }

        return ['status' => true,  'message' => tt_trans('Send Mail Successfully',cons()::LANGUAGE_NOTIFICATION)];
    }

    function addBalance(array $payloads, $user){

        $user->balance += $payloads['amount'];

        $user->save();

        $transaction = Transaction::create([
            'user_id' => $user->id,
            'trx' => getTrx(),
            'reason' => $payloads['reason'],
            'amount' => $payloads['amount'],
            'type' => '+'
        ]);

        $message = 'Balance Added Successfull';

        event(new NotificationEvent($transaction, $user, $message, 'add_balance'));


        return ['status' => true,'message' => tt_trans('Balance added successfully',cons()::LANGUAGE_NOTIFICATION)];
        
    }

    function subBalance(array $payloads, $user){

        $user->balance -= $payloads['amount'];

        if($user->balance < 0){
            return ['status' => false,'message' => tt_trans('User does not have enough balance to subtruct',cons()::LANGUAGE_NOTIFICATION)];
        }

        $user->save();

        $transaction = Transaction::create([
            'user_id' => $user->id,
            'trx' => getTrx(),
            'reason' => $payloads['reason'],
            'amount' => $payloads['amount'],
            'type' => '-'
        ]);

      
        event(new NotificationEvent($transaction, $user, 'Subtruct by admin from your balance', 'sub_balance'));

        return ['status' => true,'message' => tt_trans('Balance subtruct successfully',cons()::LANGUAGE_NOTIFICATION)];
        
    }

    function sendMail($payloads, $user){

        event(new NotificationEvent($user, $user, $payloads,'general_mail'));
        
        return ['status' => true,'message' => tt_trans('Mail send successfully',cons()::LANGUAGE_NOTIFICATION)];
    }

    function updateUserProfile($payloads, $user){

        $user->mobile = $payloads['mobile'];

        $user->save();

        unset($payloads['mobile']);

        $user->address->updateOrCreate(['user_id' => $user->id],$payloads);

        return ['status' => true,'message' => tt_trans('Profile updated successfully',cons()::LANGUAGE_NOTIFICATION)];
        
    }
}