<?php

namespace App\Services\Backend\Withdraw;

use App\Events\NotificationEvent;
use App\Models\Transaction;
use App\Models\WithdrawMethod;

class WithdrawService
{
    function createMethod(array $payloads)
    {
        if (isset($payloads['image'])) {
            $payloads['image'] = storeFile($payloads['image'], 'withdraw');
        }

        WithdrawMethod::create($payloads);

        return ['status' => true, 'message' => tt_trans('Method created successfull')];
    }

    function updateMethod(array $payloads, $method)
    {
        if (isset($payloads['image'])) {
            $payloads['image'] = storeFile($payloads['image'], 'withdraw', $method->image);
        }

        $method->update($payloads);

        return ['status' => true, 'message' => tt_trans('Method update successfull')];
    }

    function acceptWithdrawRequest($withdraw){

        $withdraw->status = cons()::ACCEPTED;

        $withdraw->save();

        $message = 'Congratutaions! your withdraw request accepted';

        event(new NotificationEvent($withdraw, $withdraw->user, $message, 'withdraw_accepted'));
        
        return ['status' => true,'message' => tt_trans('Withdraw accepted successfully',cons()::LANGUAGE_NOTIFICATION)];
    }

    function rejectWithdrawRequest($withdraw, $payloads){
        $withdraw->status = cons()::REJECTED;
        $withdraw->reason = $payloads['reason'];

        $withdraw->save();

        $user = $withdraw->user;

        $user->balance = $user->balance + $withdraw->withdraw_amount;

        $user->save();

        Transaction::create([
            'user_id' => $user->id,
            'amount' => $withdraw->withdraw_amount,
            'reason' => $payloads['reason'],
            'trx' => getTrx(),
            'type' => '+'
        ]);

        event($withdraw, $user, 'Ohh! your withdraw request rejected', 'withdraw_rejected');

        
        return ['status' => true,'message' => tt_trans('Withdraw rejected successfully',cons()::LANGUAGE_NOTIFICATION)];
    }
}
