<?php

namespace App\Services\Frontend\Auction;

use App\Models\Auction;

class AuctionService
{

    function store($payloads)
    {
        $user = user();

        if ($user->token < $payloads['tokens']) {
            return ['status' => false, 'message' => tt_trans('Not enough tokens', cons()::LANGUAGE_NOTIFICATION)];
        }

        $percentage = $payloads['expected_profit_percentage'];
        $currentPrice = getActiveStage()['stage']->base_price;
        $expectedProfit = ($percentage / 100) * $currentPrice;
        $newPrice = $currentPrice + $expectedProfit;

        $auction = new Auction();
        $auction->user_id = $user->id;
        $auction->trx = getTrx();
        $auction->tokens = $payloads['tokens'];
        $auction->expected_profit_percentage = $percentage;
        $auction->token_base_price = $newPrice;
        $auction->end_date = dateFormatter($payloads['end_date'], 'Y-m-d h:i:s');
        $auction->save();

        $user->token -= $auction->tokens;
        $user->save();

        return ['status' => true, 'message' => tt_trans('Auction created successfully', cons()::LANGUAGE_NOTIFICATION)];
    }
}
