<?php

namespace App\Services\Frontend\Auth;

use App\Events\NotificationEvent;
use App\Models\PasswordResetToken;
use App\Models\User;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;

class ForgetPasswordService
{
    function sendVerificationCode($payloads)
    {
        $token = rand(1, 999999);

        $user = User::where('email', $payloads['email'])->first();

        if (!$user) {
            return ['status' => false, 'message' => tt_trans('Invalid Email', cons()::LANGUAGE_NOTIFICATION)];
        }

        $reset = PasswordResetToken::updateOrCreate(
            ['email' => $payloads['email']],
            [
                'token' => $token,
            ],
        );

        event(new NotificationEvent($reset, $user, '', 'password_rest'));

        return ['status' => true, 'message' => tt_trans('Reset code send to your mail', cons()::LANGUAGE_NOTIFICATION)];
    }

    function codeVerify(array $payloads)
    {
        $email = Cache::get('email');

        if (!$email) {
            return ['status' => false, 'message' => tt_trans('Code Expired', cons()::LANGUAGE_NOTIFICATION)];
        }
        $isValidCode = DB::table('password_reset_tokens')
            ->where('email', $email)
            ->where('token', $payloads['code'])
            ->first();

        if (!$isValidCode) {
            return ['status' => false, 'message' => tt_trans('Invalid Code', cons()::LANGUAGE_NOTIFICATION)];
        }

        DB::table('password_reset_tokens')
            ->where('email', $email)
            ->where('token', $payloads['code'])
            ->delete();

        return ['status' => true, 'message' => tt_trans('Verfiy code successfully', cons()::LANGUAGE_NOTIFICATION)];
    }

    function resetPassword(array $payloads)
    {
        $email = Cache::get('email');

        

        if (!$email) {
            return ['status' => false, 'message' => tt_trans('Code Expired', cons()::LANGUAGE_NOTIFICATION)];
        }

        $admin = User::where('email', $email)->first();

        if (!$admin) {
            return ['status' => false, 'message' => tt_trans('Invalid Email', cons()::LANGUAGE_NOTIFICATION)];
        }

        $admin->password = bcrypt($payloads['password']);

        $admin->save();

        return ['status' => true, 'message' => tt_trans('Password Reset Successfully', cons()::LANGUAGE_NOTIFICATION)];
    }
}
