<?php
namespace App\Services\Frontend\Auth;

use Illuminate\Support\Facades\Auth;

class LoginService
{
    function login(array $payloads)
    {
        if (isset($payloads['g-recaptcha-response'])) {
            unset($payloads['g-recaptcha-response']);
        }

        if (Auth::attempt($payloads)) {

            loginLog(user());

            return ['status' => true, 'message' => tt_trans('Successfully logged In')];
        }
        return ['status' => false, 'message' => tt_trans('Invalid login credentials')];
    }
}
