<?php

namespace App\Services\Frontend\Auth;

use App\Models\Currency;
use App\Models\Transaction;
use App\Models\User;
use App\Models\UserAbility;
use App\Models\UserAddress;
use App\Models\UserReferral;
use Illuminate\Support\Str;
use Illuminate\Validation\ValidationException;

class RegisterService
{
    function createUser(array $payloads)
    {
        $payloads['username'] = $this->generateUsername($payloads['f_name'], $payloads['l_name']);

        $payloads['password'] = bcrypt($payloads['password']);

        $country = $payloads['country'];

        unset($payloads['country']);

        $referredUser = '';

        if (request()->username) {
            $referredUser = User::where('username', request()->username)->first();

            if (!$referredUser) {
                throw ValidationException::withMessages([
                    'error' => tt_trans('No Referred User Found', cons()::LANGUAGE_NOTIFICATION),
                ]);
            }
        }

        $payloads['mobile'] = str_replace('-','', $payloads['mobile']);

        unset($payloads['country_code']);


        $user = $this->create($payloads);

        $this->userAbility($user);

        $this->userAddress($user, $country);

        $this->createTransaction($user);

        if ($referredUser) {
            $this->createReferral($user, $referredUser);

            if (tc()->get('signup_bonus') > 0) {
                sendReferralCommission($user, tc()->get('signup_bonus'), cons()::REFERRAL);
            }
        }

        pushNotification(['user_id' => $user->id, 'message' => $user->username . ' registered into system', 'type' => 'success'], 'admin-notification');

        return ['status' => true, 'message' => tt_trans('Sign up completed', cons()::LANGUAGE_NOTIFICATION), 'user' => $user];
    }

    function generateUsername($firstName, $lastName)
    {
        $username = Str::slug($firstName . '.' . $lastName, '');

        $originalUsername = $username;

        $counter = 1;

        while (User::where('username', $username)->exists()) {
            $username = $originalUsername . $counter;
            $counter++;
        }

        return $username;
    }

    function create(array $payloads)
    {
        return User::create($payloads);
    }

    function userAbility($user)
    {
        $google2fa = new \PragmaRX\Google2FAQRCode\Google2FA();

        UserAbility::create([
            'user_id' => $user->id,
            'secret_code' => $google2fa->generateSecretKey(),
        ]);
    }

    function userAddress($user, $country)
    {
        UserAddress::create(['user_id' => $user->id, 'country' => $country]);
    }

    function createReferral($user, $referredUser)
    {
        UserReferral::create([
            'user_id' => $referredUser->id,
            'referred_user_id' => $user->id,
        ]);
    }

    function createTransaction($user)
    {
        if (tc()->get('signup_bonus') > 0) {
            $user->balance = +tc()->get('signup_bonus');

            $user->save();

            Transaction::create([
                'user_id' => $user->id,
                'trx' => getTrx(),
                'reason' => 'Sign up Bonus',
                'amount' => tc()->get('signup_bonus'),
                'type' => '+',
            ]);
        }
    }

   
}
