<?php

namespace App\Services\Frontend\Authorize;

use App\Events\NotificationEvent;
use App\Models\KycRequest;
use App\Models\KycSetting;

class AuthorizationService{
    function emailVerify(array $payloads){
        $user = user();

        if($user->verification_code != $payloads['code']){
            return ['status' => false,'message' => tt_trans('Invalid Code',cons()::LANGUAGE_NOTIFICATION)];
        }

        $user->verification_code = null;

        $user->save();

        $user->ability->email_verified = 1;

        $user->ability->save();

        return ['status' => true,'message' => tt_trans('Successfully verify your email',cons()::LANGUAGE_NOTIFICATION)];
    }

    function smsVerify(array $payloads){
        $user = user();

        if($user->verification_code != $payloads['code']){
            return ['status' => false,'message' => tt_trans('Invalid Code',cons()::LANGUAGE_NOTIFICATION)];
        }

        $user->verification_code = null;

        $user->save();

        $user->ability->sms_verified = 1;

        $user->ability->save();

        return ['status' => true,'message' => tt_trans('Successfully verified using sms',cons()::LANGUAGE_NOTIFICATION)];
    }

    function kycVerification(array $payloads){

        $kyc = KycSetting::latest()->get();

        $kycRequest = [];

        foreach ($kyc as $kyc) {
            if(is_file($payloads[$kyc->field_name])){
                $kycRequest[$kyc->field_name] = storeFile($payloads[$kyc->field_name], 'kyc');
            }else{
                $kycRequest[$kyc->field_name] = $payloads[$kyc->field_name];
            }
        }

        $kyc = KycRequest::create([
            'user_id' => user()->id,
            'kyc' => $kycRequest
        ]);

        user()->ability->kyc_verified = cons()::PENDING;

        user()->ability->save();

        $message = tt_trans(user()->username . ' request for kyc verification',cons()::LANGUAGE_NOTIFICATION);


        event(new NotificationEvent($kyc, user(), $message, 'kyc_verification_request'));
        

        return ['status' => true,'message' => tt_trans('Kyc Request Pending',cons()::LANGUAGE_NOTIFICATION)];

        
    }
}