<?php
namespace App\Services\Frontend\Deposit;

use App\Events\NotificationEvent;
use App\Models\Deposit;
use App\Models\Gateway;

class DepositService
{
    function deposit($payloads)
    {

        $method = Gateway::findOrFail($payloads['gateway_id']);

        $charge = $method->type == cons()::FIXED ? $method->charge : ($payloads['amount'] * $method->charge) / 100;

        $totalAmount = $payloads['amount'] + $charge;

        $totalAmountInGatewayCurrency = $totalAmount * $method->rate;

        $payloads = [
            'method_id' => $method->id,
            'user_id' => user()->id,
            'trx' => getTrx(),
            'amount' => $payloads['amount'],
            'charge' => $charge,
            'total_amount' => $totalAmount,
            'rate' => $method->rate,
            'amount_in_gateway_currency' => $totalAmountInGatewayCurrency,
            'type' => cons()::ONLINE_GATEWAY,
            'module' => cons()::DEPOSIT
        ];

        session([
            'transaction' => $payloads
        ]);

        return ['status' => true, 'message' => tt_trans('Confirm your deposit request', cons()::LANGUAGE_NOTIFICATION)];
    }

    function offlineConfirmation($payloads)
    {

        $data = session('transaction') ?? [];


        if (count($data) <= 0) {
            return ['status' => false, 'message' => tt_trans('Invalid Deposit Request', cons()::LANGUAGE_NOTIFICATION)];
        }

        $method = Gateway::findOrFail($data['method_id']);

         if ($method->gateway_type == cons()::OFFLINE_GATEWAY) {
            $proofs = $method->parameters->proof;

            $proofRequest = [];

            foreach ($proofs as $proof) {
                if ($proof->field_name != null) {
                    if (is_file($payloads['proof'][$proof->field_name])) {
                        $proofRequest[$proof->field_name] = storeFile($payloads['proof'][$proof->field_name], 'deposit');
                    } else {
                        $proofRequest[$proof->field_name] = $payloads['proof'][$proof->field_name];
                    }
                }
            }

            $data['proof'] = $proofRequest;
            $data['type'] = cons()::OFFLINE_GATEWAY;
        }

        
        session()->put('transaction', $data);
        
        unset($data['module']);
        
        $deposit = Deposit::create($data);

        $deposit->refresh();

        $user = user();

        $message = user()->username . ' request for a deposit';

        event(new NotificationEvent($deposit, $user, $message, 'deposit_request'));

        return ['status' => true, 'message' => tt_trans('Deposit Request Successfully', cons()::LANGUAGE_NOTIFICATION)];
    }
}
