<?php

namespace App\Services\Frontend\Payment;

use App\Events\NotificationEvent;
use App\Models\StagePurchase;
use App\Models\Gateway;
use App\Models\Stage;

class PaymentService
{
    function payment($payloads)
    {

        $method = Gateway::findOrFail($payloads['gateway_id']);

        $charge = $method->type == cons()::FIXED ? $method->charge : ($payloads['amount'] * $method->charge) / 100;

        $totalAmount = $payloads['amount'] + $charge;

        $totalAmountInGatewayCurrency = $totalAmount;

        $payloads = [
            'method_id' => $method->id,
            'user_id' => user()->id,
            'trx' => getTrx(),
            'amount' => $payloads['amount'],
            'charge' => $charge,
            'total_amount' => $totalAmount,
            'rate' => $method->rate,
            'amount_in_gateway_currency' => $totalAmountInGatewayCurrency,
            'type' => cons()::ONLINE_GATEWAY,
            'module' => cons()::PAYMENT
        ];

        session([
            'transaction' => $payloads
        ]);

        return ['status' => true, 'message' => tt_trans('Confirm your payment request', cons()::LANGUAGE_NOTIFICATION)];
    }

    function offlineConfirmation($payloads)
    {

        $data = session('transaction') ?? [];

        if (count($data) <= 0) {
            return ['status' => false, 'message' => tt_trans('Invalid Deposit Request', cons()::LANGUAGE_NOTIFICATION)];
        }

        $method = Gateway::findOrFail($data['method_id']);

        if ($method->gateway_type == cons()::OFFLINE_GATEWAY) {
            $proofs = $method->parameters->proof;

            $proofRequest = [];

            foreach ($proofs as $proof) {
                if ($proof->field_name != null) {
                    if (is_file($payloads['proof'][$proof->field_name])) {
                        $proofRequest[$proof->field_name] = storeFile($payloads['proof'][$proof->field_name], 'deposit');
                    } else {
                        $proofRequest[$proof->field_name] = $payloads['proof'][$proof->field_name];
                    }
                }
            }

            $data['proof'] = $proofRequest;
            $data['type'] = cons()::OFFLINE_GATEWAY;
        }


        session()->put('transaction', $data);

        unset($data['module']);
        $stageData = session("stage_buy_informations");
        $stage = Stage::find($stageData['stage_id']);

        $purchase = new StagePurchase();
        $purchase->trx = $data['trx'];
        $purchase->stage_id = $stage->id;
        $purchase->user_id = $data['user_id'];
        $purchase->token = $stageData['token'];
        $purchase->bonus_token = $stage->bonus_token;
        $purchase->base_price = $stage->base_price;
        $purchase->total_price = $data['total_amount'];
        $purchase->status = cons()::PENDING;
        $purchase->payment_type = cons()::WITH_GATEWAY;
        $purchase->method_id = $method->id;
        $purchase->currency_id = $stageData['currency_id'];
        $purchase->payment_proof = $data['proof'] ?? "";
        $purchase->save();

        $user = user();

        $message = user()->username . ' request for a purchase';

        event(new NotificationEvent($purchase, $user, $message, 'offline_purchase_request'));

        return ['status' => true, 'message' => tt_trans('Purchase Request Successfully', cons()::LANGUAGE_NOTIFICATION)];
    }
}
