<?php

namespace App\Services\Frontend\Profile;

use Illuminate\Support\Facades\Hash;

class ProfileService
{
    function updateProfileImage($payloads)
    {
        $image = user()->image;

        if ($payloads['image']) {
            $image = storeFile($payloads['image'], 'user', $image);
        }

        $user = user();

        $user->image = $image;

        $user->save();

        return ['status' => true, 'message' => tt_trans('Profile image update successfully', cons()::LANGUAGE_NOTIFICATION)];
    }

    function updateProfile($payloads)
    {
        $user = user();

        $user->update($payloads);

        return ['status' => true, 'message' => tt_trans('Profile updated successfully', cons()::LANGUAGE_NOTIFICATION)];
    }

    function updateAddress($payloads)
    {
        $user = user();

        $user->address->update($payloads);

        return ['status' => true, 'message' => tt_trans('Address updated successfully', cons()::LANGUAGE_NOTIFICATION)];
    }

    function updatePassword($payloads)
    {
        if (!Hash::check($payloads['old_password'], user()->password)) {
            return ['status' => false, 'message' => tt_trans('Old password not matched', cons()::LANGUAGE_NOTIFICATION)];
        }

        $user = user();

        $user->password = bcrypt($payloads['password']);

        $user->save();

        return ['status' => true, 'message' => tt_trans('Password updated successfully', cons()::LANGUAGE_NOTIFICATION)];
    }
}
